﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Raport o stażu pracy</TITLE>
		<script runat="server">

	Date data;
	DefPodstawyStazu zatrudnienie;
	DefPodstawyStazu wykształcenie;
	
    void dc_ContextLoad(Object sender, EventArgs e) {
		data = ((ActualDate)dc[typeof(ActualDate)]).Actual;
		
		KadryModule kadry = KadryModule.GetInstance(dc);
		zatrudnienie = kadry.DefPodstawStazu.Zatrudnienie;
		wykształcenie = kadry.DefPodstawStazu.Wyksztalcenie;
	}
	
    private void Grid_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        Pracownik pracownik = (Pracownik)args.Row;
        
        StazPracy firma = pracownik.StażPracy(data);
        StazPracy poza = pracownik.StażPracy(Date.Empty, zatrudnienie);
        StazPracy nauka = pracownik.StażPracy(Date.Empty, wykształcenie);
        
        StazPracy praca = (firma + poza).Normalizuj();
        StazPracy razem = (praca + nauka).Normalizuj();
        
        colFirma.EditValue = firma;
        colPoza.EditValue = poza;
        colNauka.EditValue = nauka;
        colPraca.EditValue = praca;
        colRazem.EditValue = razem;
    }
			
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" title="Raport o stażu pracy|</strong>Wydział: <strong>{0}|</strong>Z podwydziałami: <strong>{1}|</strong>Okres: <strong>{2}|</strong>Aktualny: <strong>{3}"
				DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio"
				DataMember2="KadryPracownicyViewInfo+PrParams.Okres" DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny"></eb:ReportHeader>
			<P>
				<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace"
					onbeforerow="Grid_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
						<ea:GridColumn Width="40" Align="Left" DataMember="Pracownik.NazwiskoImię" Caption="Pracownik"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Left" DataMember="Kod" Caption="Kod"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Left" DataMember="Workers.Info.Historia.Etat.OkresZatrudnienia.From"
							Caption="Zatrudnienie|od dnia"></ea:GridColumn>
						<ea:GridColumn Align="Center" Caption="Staż pracy (lata, miesiące, dni)~w firmie" Format="{0:b}"
							ID="colFirma"></ea:GridColumn>
						<ea:GridColumn Align="Center" Caption="Staż pracy (lata, miesiące, dni)~poza firmą" Format="{0:b}"
							ID="colPoza"></ea:GridColumn>
						<ea:GridColumn Align="Center" Caption="Staż pracy (lata, miesiące, dni)~poza firmą|i w firmie"
							Format="{0:b}" ID="colPraca"></ea:GridColumn>
						<ea:GridColumn Align="Center" Caption="Staż pracy (lata, miesiące, dni)~nauka" Format="{0:b}" ID="colNauka"></ea:GridColumn>
						<ea:GridColumn Align="Center" Caption="Staż pracy (lata, miesiące, dni)~razem" Format="{0:b}" ID="colRazem"></ea:GridColumn>
					</Columns>
				</ea:Grid>
			</P>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>
